/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.util.skills.SimpleSkill;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

@ParametersAreNonnullByDefault
public class ApplySimpleSkill
extends LootFunction {
    private final SkillType<? extends SimpleSkill> skillType;
    private final RandomValueRange valueRange;
    private final float incrementAmount;

    private ApplySimpleSkill(LootCondition[] conditionsIn, RandomValueRange valueRange, SkillType<? extends SimpleSkill> skillType, float incrementAmount) {
        super(conditionsIn);
        this.valueRange = valueRange;
        this.skillType = skillType;
        this.incrementAmount = incrementAmount;
    }

    @Nonnull
    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        SimpleSkill skill;
        IPlayerData skills;
        Entity entity = context.func_186495_b();
        if (entity instanceof EntityPlayer && (skills = (IPlayerData)entity.getCapability(CapabilityPlayerData.CAPABILITY, null)) != null && (skill = skills.getSkill(this.skillType)) != null) {
            stack.func_190920_e(1 + (int)((float)this.valueRange.func_186511_a(rand) - this.valueRange.func_186509_a() * (1.0f - skill.getTotalLevel())));
            skill.add(this.incrementAmount);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplySimpleSkill> {
        public Serializer(ResourceLocation location) {
            super(location, ApplySimpleSkill.class);
        }

        public void serialize(JsonObject object, ApplySimpleSkill functionClazz, JsonSerializationContext serializationContext) {
            object.add("skill", serializationContext.serialize((Object)functionClazz.skillType.getName()));
            object.add("add", serializationContext.serialize((Object)Float.valueOf(functionClazz.incrementAmount)));
            object.add("count", serializationContext.serialize((Object)functionClazz.valueRange));
        }

        @Nonnull
        public ApplySimpleSkill deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            String skillName = JsonUtils.func_151200_h((JsonObject)object, (String)"skill");
            float amount = JsonUtils.func_151217_k((JsonObject)object, (String)"add");
            SkillType<SimpleSkill> skillType = SkillType.get(skillName, SimpleSkill.class);
            RandomValueRange valueRange = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            if (skillType == null) {
                throw new JsonParseException("Unknown skill type: '" + skillName + "'");
            }
            return new ApplySimpleSkill(conditionsIn, valueRange, skillType, amount);
        }
    }
}

